#!/usr/bin/perl
#       Ldap,      (CRL)   .
use Net::LDAP;#     LDAP.    Perl  .
use strict;

my  $ldap = Net::LDAP->new('192.168.7.36', port => 62222, version => 3) or die "$@";
my  $mesg = $ldap->bind(dn => 't=L');#   L ( )      t=L
$mesg = $ldap->search(base => "", scope => 'sub', filter => "(&(ucertificateRevocationList=*)(cn=USER00001))");
#   .       .     (&(userCertificate=*)(cn=USER00001))    CRL    cn=USER00001
#         (&(userTemplate=*)(mail=d_*)).           mail=d_.
$mesg->code && die $mesg->error;   #   
my $max = $mesg->count;
printf("Count crl: %d\n",$max);
for(my $index = 0 ; $index < $max ; $index++)  #   
{
    my $entry = $mesg->entry($index);
    my $dn = $entry->dn;
    print $dn . "\n";
    my @attrs = $entry->attributes; #    
    foreach my $var (@attrs) #   
    {
        my $attr = $entry->get_value($var, asref =>1); #  
        if( defined($attr) )
        {
            foreach my $value ( @$attr )  #     
            {
                if($var eq 'certificateRevocationList')
                {
                    my $res=$ldap->extension(name => '1.3.6.1.4.1.6801.11.1.4', value => $value);
                    # $var    1.3.6.1.4.1.6801.11.1.4 (Verify)
                    #  1.3.6.1.4.1.6801.11.1.4    ,  1.3.6.1.4.1.6801.11.1.10(RA)    1.3.6.1.4.1.6801.11.1.0 (Echo)
                }
            }
        }
    }
}